<?php
$MERGED_FILE = '/tmp/bglaunch_merged.out';

// make php array from passed json file
if (!file_exists($argv[1])) 
    exit;
$srcfile = file_get_contents($argv[1]);
$srcA = json_decode($srcfile, true);
if (!is_array($srcA))
    exit;

// make php array from acumulated (merged) json file
$dstA = array();
if (file_exists($MERGED_FILE)) {
    $dstfile = file_get_contents($MERGED_FILE);
    $dstA = json_decode($dstfile, true);
}

// merge both arrays
$outA = array_merge_recursive($srcA,$dstA);

// concat error strings if needed
if (array_key_exists('error_string',$srcA) && array_key_exists('error_string',$dstA)){
    if (trim($srcA['error_string']) && trim($dstA['error_string'])){
	$outA['error_string'] = $dstA['error_string'] . "\n" . $srcA['error_string'];
    }elseif(trim($srcA['error_string'])){
	$outA['error_string'] = $srcA['error_string'];
    }elseif(trim($dstA['error_string'])){
	$outA['error_string'] = $dstA['error_string'];
    }
    //echo 'dstA[error_string]='.$dstA['error_string'].' srcA[error_string]='.$srcA['error_string'].'\n';
}

// write output into merged file
$outstring = json_encode($outA);
file_put_contents($MERGED_FILE,$outstring);

?>
