#!/bin/bash

#Run this script from terminal with -v for verbose mode.
verbose=false;
while getopts v opt; do
  case $opt in
    v)
      echo "BG launcher running in verbose mode" >&2
      verbose=true;
      ;;
  esac
done


shopt -s nullglob
servicestorun=(/tmp/app/shellscripts/*launcher.sh);

#rm -f /tmp/bglaunch_merged.out   # make really sure there is no merge file left from the past
#for every service we can run in the shellscripts directory
#  if it is already running - do nothing
#  if it is not running
#    if we have a log file from last time, add to our merged output file
#    start the service
#if we have merged output, print the output and clear the file
for service in "${servicestorun[@]}"
do
  if [ "$(pidof ${service##*/})" ]; then
    if $verbose; then
      echo "$service already launched.";
    fi
  else
    #gather together outputs from last service run if they exist
    serviceoutput="/tmp/${service##*/}.tmp"
    serviceerroroutput="/dev/null"
    if $verbose; then
      echo $serviceoutput;
    fi
    if [ -f "$serviceoutput" ]; then
      if $verbose; then
        echo "php mergeoutput.php $serviceoutput"
      fi
      php /tmp/app/shellscripts/mergeoutput.php $serviceoutput
      rm $serviceoutput
    fi

    nohup $service 0<&- 1>$serviceoutput 2>$serviceerroroutput &
    if $verbose; then
      echo "Service launched: $(pidof ${service##*/})";
    fi
  fi
done

if [ -f /tmp/bglaunch_merged.out ]
then
    cat /tmp/bglaunch_merged.out
    rm /tmp/bglaunch_merged.out
fi
if $verbose; then
  echo "Exit Script"
fi
