<?php
// ***********************************************************
// XML-RPC query
// ***********************************************************
function xmlrpc($url, $method, $params = array(), $types = array(), $encoding = 'utf-8') {
  foreach ($types as $key => $val) {
    xmlrpc_set_type($params[$key], $val);
  }
  $context = stream_context_create(array('http' => array(
    'method' => "POST",
    'header' => "Content-Type: text/xml",
    'content' => xmlrpc_encode_request($method, $params, array('encoding' => $encoding)),
    'timeout' => 2
  )));
  $xmlrpcdata = file_get_contents($url, false, $context);
  $xmlObject = xmlrpc_decode($xmlrpcdata, $encoding);
  //print_r($xmlObject);
  return reduceXMLRPCToNative($xmlObject);
}

// ***********************************************************
// reduce arrays of properties to a single array
//   - array of array('property'=>'property_name', 'value'=>'property_value') is reduced to array of 'property_name'=>'property_value'
//   - other data are kept without change
// ***********************************************************
function reduceXMLRPCToNative($array) {
  if ( !is_array($array) )
  return $array;
  $ret = array();
  foreach($array as $itemKey=>$itemVal) {
    if (is_array($itemVal) && array_key_exists('property',$itemVal) && array_key_exists('value',$itemVal)) {
      if (is_array($itemVal['value']))
      $ret[$itemVal['property']] = reduceXMLRPCToNative($itemVal['value']);
      else
      $ret[$itemVal['property']] = $itemVal['value'];
    } else {
      $ret[$itemKey] = reduceXMLRPCToNative($itemVal);
    }
  }
  return $ret;
}
