<?php
include_once('debug_utility.php');
include_once('xmlrpc.php');
header('Content-type: application/json');
chdir(__DIR__);
ini_set("error_reporting",E_ALL);  // error reporting level
ini_set('display_errors', true);   // print errors into output ?
ini_set("log_errors",true);        // log errors into log
//ini_set("error_log","/var/log/php.log");  // log into given file instead of web server's log

// is set to true if the script is executed on application start
$_STARTUP_ = false;

// all input tags passed as POST parameters are stored into $input_tags array
$input_tags = $_POST;

// this tag list is converted to json and echoed to output at the end of this script sd
$output_tags = array();

// this string will be displayed by OI in top red message box window
$output_error_string = '';


// ***********************************************************
// Get binary value of bit in $number at location $bit
// ***********************************************************
function getNumBitValue($number=0, $bit=0){
    // echo "$number & 1<<$bit \n";
    if(is_numeric($number) && is_numeric($bit) && $bit<16){
        return $number & 1<<$bit;
    }else{
        return 0;
    }
}

// ***********************************************************
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// main script starts here
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// ***********************************************************
$_readTagCache=array();
function readTagsInCache(&$tagCache){
	global $debugEnabled, $output_error_string;
	addTiming(__FILE__.' '.__FUNCTION__.'readTagsInCache',__LINE__);
	//try to request array of tags, otherwise get each one singly
	// echo "$tagName Not in cache\n";
	$xml_rpc_method='readTagValue';
	$hostAddr='127.0.0.1';
	$hostPort = 8081;
	$tagsToGet=array();

	foreach($tagCache as $tagName=> &$tagValue){
		if(!isset($tagValue)){
			$tagsToGet[]=$tagName;
		}
	}
	if(!count($tagsToGet)){
		if($debugEnabled)echo "No tags to get in readTagsInCache\n";
		return NULL;
	}
	addTiming(__FILE__.' '.__FUNCTION__.'Start Read',__LINE__);
	if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' REQUEST DATA FROM OI '."\n";
	$oi = @xmlrpc("http://$hostAddr:$hostPort/", $xml_rpc_method, $tagsToGet);
	if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' RECEIVE DATA FROM OI '.print_r($oi,true)."\n";
	addTiming(__FILE__.' '.__FUNCTION__.'End Read',__LINE__);
	if (empty($oi) || !is_array($oi) || !isset($oi['ok']) || !isset($oi['tags']) || !is_array($oi['tags'])) {
		addTiming(__FILE__.' '.__FUNCTION__.'Error read',__LINE__);
		if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' -- '.print_r($oi,true)."\n";
	}else{
		//we got an OK signal, parse results
        if($oi['ok']!='success'){
            $output_error_string.='[Read Errors: '.$oi['ok'].']';
        }
		//update cache, remove from tagList
		addTiming(__FILE__.' '.__FUNCTION__.'Start parse response',__LINE__);
		foreach($oi['tags'] as $tagData){
			if(isset($tagData['name'])){
				//update cache
				if(array_key_exists($tagData['name'], $tagCache)){
					$tagCache[$tagData['name']]=$tagData['value'];
				}
				//update tagsToGet list
				$tagsToGetIndex=array_search($tagData['name'],$tagsToGet);
				if($tagsToGet!==FALSE){
					unset($tagsToGet[$tagsToGetIndex]);
				}
			}
		}
		addTiming(__FILE__.' '.__FUNCTION__.'End parse response',__LINE__);
	}
	if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' -- '.print_r($tagsToGet,true)."\n";
	addTiming(__FILE__.' '.__FUNCTION__.'Start one by one read',__LINE__);
	foreach($tagsToGet as $tagToGet){
		if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' REQUEST DATA FROM OI: '.$tagToGet."\n";
		$oi = @xmlrpc("http://$hostAddr:$hostPort/", $xml_rpc_method, $tagToGet);
		if (empty($oi) || !is_array($oi) || !isset($oi['ok']) || !isset($oi['tags']) || !is_array($oi['tags']) || !count($oi['tags'])) {
			if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' -- '.print_r($oi,true)."\n";
		}else{
			if(isset($oi['tags'][0]['value'])){
				$tagCache[$tagToGet]=$oi['tags'][0]['value'];
			}
		}
	}
	addTiming(__FILE__.' '.__FUNCTION__.'End one by one read',__LINE__);
}
function readTag($tags=''){
	global $_readTagCache,$debugEnabled;
	if($debugEnabled)echo __FILE__.':'.__LINE__.' '.__FUNCTION__.' -- '.print_r($tags,true)."\n";
	//read tag values
	// === oi xml rpc call
	// echo "looking up ".print_r($tags,true)."\n";
	//if we're looking for single tag, return the cache if available
	if(!is_array($tags)){
		if(!$tags)return NULL;
		if(!isset($_readTagCache[$tags])){
			$_readTagCache[$tags]=NULL;
		}else{
			return $_readTagCache[$tags];
		}
	}else{
		if(!count($tags))return NULL;
		//else, add tag names to our cache
		foreach($tags as $tagToRead){
			if(!isset($_readTagCache[$tagToRead])){
				$_readTagCache[$tagToRead]=NULL;
			}
		}
	}
	readTagsInCache($_readTagCache);

	if(is_array($tags)){
		$toreturn=array();
		foreach($tags as $tagToReturn){
			$toreturn[$tagToReturn]=$_readTagCache[$tagToReturn];
		}
		return $toreturn;
	}else{
		return $_readTagCache[$tags];
	}
}

$_writeTagCache=array();
function writeTagsInCache(){
	global $debugEnabled, $output_error_string, $_writeTagCache;
	$toWrite=array();
	foreach($_writeTagCache as $tagName=>$tagValue){
		$toWrite[]=array('name'=>$tagName, 'value'=>$tagValue);
	}
	if(!count($toWrite)){
		if($debugEnabled)echo "No tags to write.\n";
		return NULL;
	}
	$xml_rpc_method='writeTagValue';
	$hostAddr='127.0.0.1';
	$hostPort = 8081;
	if($debugEnabled)echo "writeTagsInCache writing:".print_r($toWrite,true)."\n";
	$oi = @xmlrpc("http://$hostAddr:$hostPort/", $xml_rpc_method, $toWrite );
	if($debugEnabled)echo "writeTagsInCache results:".print_r($oi,true)."\n";
	if (empty($oi) || !is_array($oi) || !isset($oi['ok']) ) {
		return false;
	}
    foreach($oi['tags'] as $writeResult){
        if($writeResult['write_value']!=$writeResult['read_back_value']){
            $output_error_string.='[Write Error - try to set '.$writeResult['name'].' to '.$writeResult['write_value'].', read back value was '.$writeResult['read_back_value'].']';
        }
    }
	return true;

}

function writeTag($tagName='', $tagValue=0){
	global $_writeTagCache;
	if($tagName){
		$_writeTagCache[$tagName]=$tagValue;
	}
}

register_shutdown_function('writeTagsInCache');
